
/* -*-C-*-
 ##############################################################################
 #
 # File:        trice/src/error.c 
 # RCS:         "@(#)$Revision: 1.19 $ $Date: 94/03/17 11:28:25 $"
 # Description: contains error handler for E1430 driver library
 # Author:      Doug Passey
 # Created:     
 # Language:    C
 # Package:     E1430
 # Status:      "@(#)$State: Exp $"
 #
 # (C) Copyright 1992, Hewlett-Packard Company, all rights reserved.
 #
 ##############################################################################
 #
 # This file contains the error handler for the E1430 library. The function
 # Error() is called whenever an unrecoverable error is detected by a
 # E1430 library function.
 #
 # Revisions:
 #
 ##############################################################################
*/

#    include <stdio.h>
#    include <string.h>

#include "trice.h"
#include "err1430.h"

#ifndef lint
const char i1430_error_fileId[] = "$Header: error.c,v 1.19 94/03/17 11:28:25 chriss Exp $";
#endif

static const char errorNoFormat[] = "E1430 error %d: ";

static const char * const errorStr[] = {
"Error number out of bounds",			/* shouldn't happen */
"Unable to malloc memory for %s",		/*ERR1430_MALLOC*/
"Unable to realloc memory to expand %s",	/*ERR1430_REALLOC*/
"Unable to create module state structure", 	/*ERR1430_NEW_STATE*/
"No E1430 module at logical address %s",	/*ERR1430_NO_MOD_AT_LA*/
"Module group ID %s is not valid",		/*ERR1430_NO_GROUP*/
"Illegal multi sync mode",		/*ERR1430_ILLEGAL_MULTI_SYNC_MODE*/
"Illegal ADC clock source",		/*ERR1430_ILLEGAL_ADC_CLOCK_SOURCE*/
"Illegal DSP clock source",		/*ERR1430_ILLEGAL_DSP_CLOCK_SOURCE*/
"Illegal data port",			/*ERR1430_ILLEGAL_DATA_PORT*/
"Illegal pass tag",			/*ERR1430_ILLEGAL_PASS_TAG */
"Illegal append status state",		/*ERR1430_ILLEGAL_APPEND_STATUS*/
"Illegal data type",			/*ERR1430_ILLEGAL_DATA_TYPE*/
"Illegal data size",			/*ERR1430_ILLEGAL_DATA_SIZE*/
"Illegal blocksize",			/*ERR1430_ILLEGAL_BLOCKSIZE*/
"Illegal filter output mode",		/*ERR1430_ILLEGAL_FILTER_PASS_MODE*/
"Illegal decimate state",		/*ERR1430_ILLEGAL_DECIMATE_STATE*/
"Illegal anti-alias filter state",	/*ERR1430_ILLEGAL_ANTI_ALIAS_MODE*/
"Range out of limits",			/*ERR1430_RANGE_OUT_OF_LIMITS*/
"Illegal input source",			/*ERR1430_ILLEGAL_ANTI_ALIAS_MODE*/
"Illegal data mode",			/*ERR1430_ILLEGAL_DATA_MODE*/
"Error returned by SICL ivxibusstatus()", /*ERR1430_TRIG_LINE_STATE*/
"Illegal coupling",			/*ERR1430_ILLEGAL_COUPLING*/
"Illegal trigger mode",			/*ERR1430_ILLEGAL_TRIG_MODE*/
"Illegal trigger slope",		/*ERR1430_ILLEGAL_TRIG_SLOPE*/
"Trigger level must be -1.0 -> 1.0 ",	/*ERR1430_TRIG_LIN_LEVEL_RANGE*/
"Trigger level must be 3.0 -> -85.0 ",	/*ERR1430_TRIG_LOG_LEVEL_RANGE*/
"Pretrigger exceeds size of FIFO",	/*ERR1430_PRETRIGGER_GREATER_FIFO*/
"VXI register offset, %s, is illegal",	/*ERR1430_ILLEGAL_REGISTER_OFFSET*/
"Illegal interrupt number: %s (only 0 or 1)",	/*ERR1430_ILLEGAL_INTR_NUMBER*/
"Illegal interrupt priority: %s",	/*ERR1430_ILLEGAL_INTR_PRIORITY*/
"Illegal interrupt mask: %s",		/*ERR1430_ILLEGAL_INTR_MASK*/
"Illegal filter bandwidth: 0 -> 25",	/*ERR1430_ILLEGAL_FILTER_BANDWIDTH*/
"Timeout while waiting for SYNC state",	/*ERR1430_WAIT_SYNC_TIMEOUT*/
"Only one clock master per mainframe",	/*ERR1430_ONLY_ONE_MASTER */
"Illegal sync line state",		/*ERR1430_ILLEGAL_SYNC_LINE_STATE*/
"Unable to map A16 address space",	/*ERR1430_UNABLE_TO_MAP_MEMORY*/
"Unable to open SICL session with address %s",	/*ERR1430_UNABLE_TO_OPEN_SICL*/
"Module at logical addr %s not in a group",/*ERR1430_LA_NOT_IN_MOD_GROUP*/
"Modules in group %s not in contiguous slots",	/*ERR1430_GROUP_NOT_CONTIGUOUS*/
"Module parameter, %s, not the same across module group %s", /*ERR1430_PARAMETER_UNEQUAL*/
"Illegal mag trigger bandwidth, %s, must be 0 -> 24", /*ERR1430_ILLEGAL_TRIG_BANDWIDTH*/
"Timeout waiting to trigger", 		/*ERR1430_TRIG_TIMEOUT*/
"Timeout waiting to arm", 		/*ERR1430_ARM_TIMEOUT*/
"Timeout waiting to read data at logical address %s",/*ERR1430_DATA_READ_TIMEOUT*/
"Illegal combination of filter bandwidths", 	/*ERR1430_ILLEGAL_FILTER_BW*/
"ADC error bit set on module at logical address %s",	/*ERR1430_ADC_ERROR*/
"Auto range max range exceeded at logical address %s",  /*ERR1430_AUTO_RANGE_MAX*/
"Can not open statefile: %s",			/*ERR1430_OPEN_STATEFILE*/
"Can not read from statefile: %s",		/*ERR1430_READ_STATEFILE*/
"Can not write to statefile: %s",		/*ERR1430_WRITE_STATEFILE*/
"Can not close statefile: %s",			/*ERR1430_CLOSE_STATEFILE*/
"File, %s, is not a statefile",			/*ERR1430_NOT_STATEFILE*/
"Logical Addr mismatch: statefile: %s, group: %s", /*ERR1430_MISMATCH_STATEFILE*/
"Error in system time function, gettimeofday",	/*ERR1430_SYSTEM_TIME*/
"Bus error on %s",				/*ERR1430_BUS_ERROR*/
"Illegal clock master mode",		/*ERR1430_ILLEGAL_CLOCK_MASTER_MODE*/
"Local Bus not supported in this environment", /*ERR1430_LOCAL_BUS_UNSUPPORTED*/
"Logical address decoding error: set la = %s, actual la = %s",/*ERR1430_LA_DECODE*/
"Timeout on read request for logical address, %s", /*ERR1430_LA_TIMEOUT*/
"Illegal response to D32 read request at la = %s", /*ERR1430_ILLEGAL_D32*/
"Timeout on D8 read request at la = %s",	/*ERR1430_D8_TIMEOUT*/
"Illegal response to unaligned D16 read request at la = %s",/*ERR1430_ILLEGAL_UNALIGNED_D16*/
"Illegal response to A24 read request at la = %s", /*ERR1430_ILLEGAL_RESPONSE_A24*/
"Illegal response to A32 read request at la = %s", /*ERR1430_ILLEGAL_RESPONSE_A32*/
"Incorrect response to register read at %s: %s", /*ERR1430_ILLEGAL_RESPONSE_REG*/
"Illegal response to register write at offset %s on la = %s", /*ERR1430_ILLEGAL_WRITE_RESPONSE*/
"Timeout on register write at offset %s on la = %s", /*ERR1430_WRITE_TIMEOUT*/
"Illegal response to register read at offset %s, la = %s", /*ERR1430_ILLEGAL_READ_RESPONSE*/
"No response to DSP chip read at offset %s on la = %s", /*ERR1430_NO_RESPONSE_DSP*/
"Incorrect read/write of Port Control Register at la = %s\n%s",/*ERR1430_PORT_CONTROL_RW*/
"Can't read/write to E1430_HP_PORT_CONTROL_REG at la = %s",/*ERR1430_PORT_CONTROL_BAD*/
"Illegal read during reset on module at la = %s", /*ERR1430_SOFT_RESET_FAIL*/
"Can't reset module at logical address %s\n", /*ERR1430_NO_SOFT_RESET*/
"Can't read/write E1430_TIMING_SETUP_REG at la = %s", /*ERR1430_TIMING_REG_RW*/
"Can't read E1430_VXI_STATUS_REG at la = %s",	/*ERR1430_STATUS_REG_READ*/
"Improper DSP clock present on la = %s, TIMING_SETUP_REG = %s",/*ERR1430_IMPROPER_DSP_CLOCK*/
"ADC clock missing on la = %s, E1430_TIMING_SETUP_REG = %s", /*ERR1430_MISSING_ADC_CLOCK*/
"Improper ADC clock present on la = %s, TIMING_SETUP_REG = %s",/*ERR1430_IMPROPER_ADC_CLOCK*/
"DSP clock missing on la = %s, E1430_TIMING_SETUP_REG = %s", /*ERR1430_MISSING_DSP_CLOCK*/
"16-bit real data error on module at la = %s", /*ERR1430_REAL_DATA_16*/
"16-bit complex data error on module at la = %s", /*ERR1430_COMPEX_DATA_16*/
"32-bit real data error on module at la = %s", /*ERR1430_REAL_DATA_32*/
"32-bit complex data error on module at la = %s", /*ERR1430_COMPEX_DATA_32*/
"Error saving or tagging multipass data at la = %s",/*ERR1430_MULTIPASS_DATA*/
"Error in data decimation pattern at la = %s",/*ERR1430_DECIMATION_PATTERN*/
"Error in pass tag for 24-bit format at la = %s", /*ERR1430_PASSTAG_24*/
"Error in appending status byte at la = %s", /*ERR1430_APPEND_STATUS*/
"Requested status byte not appended to data block at la = %s",/*ERR1430_NO_STATUS_BYTE*/
"Incorrect exit from IDLE state at la = %s", /*ERR1430_INCORRECT_IDLE_EXIT*/
"Failed to enter TRIGGER state properly at la = %s", /*ERR1430_FAIL_ENTER_TRIGGER*/
"Failed to enter MEAS state properly at la = %s", /*ERR1430_FAIL_ENTER_MEASURE*/
"Failed to enter IDLE state properly at la = %s", /*ERR1430_FAIL_ENTER_IDLE*/
"Failed to enter ARM state properly at la = %s", /*ERR1430_FAIL_ENTER_ARM*/
"Failed to auto trigger properly at la = %s", /*ERR1430_FAIL_AUTO_TRIGGER*/
"Failed FIFO memory test: %s", /*ERR1430_FIFO_MEMORY_TEST*/
"Illegal trigger delay", /*ERR1430_ILLEGAL_TRIGGER_DELAY*/
"Auto zero failed at la = %s", /*ERR1430_AUTO_ZERO_FAIL*/
"Extra data words in block: expected %s, got %s", /*ERR1430_EXTRA_DATA_WORDS*/
"Selftest failure to reset DSP section", /*ERR1430_RESET_DSP*/
"Fails call to SICL ivxirminfo", /*ERR1430_VXI_INFO*/
"Unexpected priority %s interrupt from interrupt generator %s", /*ERR1430_UNEXPECTED_INTERRUPT*/
"Missing ARMED interrupt on line %s from intr generator %s", /*ERR1430_MISSING_ARMED_INTR*/
"Missing READ_VALID interrupt on line %s from intr generator %s", /*ERR1430_MISSING_READ_VALID_INTR*/
"Missing BLOCK_READY interrupt on line %s from intr generator %s", /*ERR1430_MISSING_BLOCK_READY_INTR*/
"Missing MEAS_DONE interrupt on line %s from intr generator %s", /*ERR1430_MISSING_MEAS_DONE_INTR*/
"Incorrect interrupt status: expected %s, got %s", /*ERR1430_WRONG_INTR_STATUS*/
"No interrupt lines allocated to this device", /*ERR1430_NO_INTR_LINES*/
"Failure to install interrupt handler", /*ERR1430_INTERRUPT_INSTALL*/
"Failure to enable interrupt handler", /*ERR1430_INTERRUPT_ENABLE*/
"IOCTL failure while %s", /*ERR1430_IOCTL_ERROR*/
"Failure while reading keyboard", /*ERR1430_RS232_READ_ERROR*/
"Offset DAC error: value %s is outside range %s", /*ERR1430_OFFSET_DAC_BAD*/
"Illegal exit of TRIG state",	/*ERR1430_ILLEGAL_TRIG_EXIT*/
"Failure to exit TRIG state",	/*ERR1430_FAIL_TRIG_EXIT*/
"Wrong trigger delay: %s, %s",	/*ERR1430_FAIL_TRIG_DELAY*/
"Triggered on wrong slope %s",	/*ERR1430_WRONG_TRIG_SLOPE*/
"Failed to trigger in slope trigger mode %s",	/*ERR1430_FAIL_TRIG_SLOPE*/
"Reread failure with %s",	/*ERR1430_REREAD_FAILURE*/
"Illegal LBUS mode: %s",	/*ERR1430_ILLEGAL_LBUS_MODE*/
"Illegal LBUS reset state: %s",	/*ERR1430_ILLEGAL_LBUS_RESET*/
"Sample clock frequency not equal for group",	/*ERR1430_SAMPLE_CLOCK_FREQ*/
"Illegal data reread state",	/*ERR1430_ILLEGAL_DATA_REREAD*/
"%s not valid group ID, use groupID not logical address",/*ERR1430_GROUP_NOT_LA*/
"Module group, %s , is not a synchronous group",/*ERR1430_NOT_SYNCHRONOUS_GROUP*/
"No clock master in module group, %s",/*ERR1430_NO_MASTER*/
"ADC overload bit set on module at logical address %s",	/*ERR1430_ADC_OVERLOAD*/
"Illegal clock value       0 -> 1",	/*ERR1430_ILLEGAL_CLOCK_VALUE*/
"Illegal filter value 0 -> 1",	/*ERR1430_ILLEGAL_FILTER_SELECTION*/
"Illegal buffer size    > 1",	/*ERR1430_ILLEGAL_BUFFER_SIZE*/
"Illegal resample output ratio .25 -> 1000",	/*ERR1430_ILLEGAL_RESAMPLE OUTPUT RATI0*/

};

SHORTSIZ16 e1430_print_errors(SHORTSIZ16 state)
{
  e1430_printFlag = state;
  return (0);
}


SHORTSIZ16 e1430_return_error(SHORTSIZ16 state)
{
  e1430_returnError = state;
  return (0);
}

/*****************************************************************************
 *
 * Return error string.
 *
 *****************************************************************************/
char *e1430_get_error_string(void)
{
  return (e1430_error_string);
}

#ifdef _WINDLL
/*****************************************************************************
 *
 * Similar to above, but fills an array with the error string.
 * This may easier to call in mixed language environments.
 * The array is assumed to have 255 elements.  Returns the number
 * of characters written.
 *
 *****************************************************************************/
SHORTSIZ16 e1430_fill_error_string( SHORTSIZ16 *stringa )
{
  SHORTSIZ16 len = 0; 
  char * p; 

  p = e1430_error_string;
  while ((*p != 0) && (len<255)) {
     *(stringa++) = *(p++);
     len++;
  }
  return (len);
}
#endif /* _WINDLL */


SHORTSIZ16 i1430_Error(SHORTSIZ16 errorNum, char *parm1, char *parm2)
{
  char temp[256];
  int index;

  index = errorNum - ERR1430_ERROR_OFFSET; /* get index into errorStr array */

  if(index <= 0 || errorNum > ERR1430_LAST_ERROR_NUMBER) {
    return (-1);
  }

  /* put error number in parens for error message */
  (void)sprintf(e1430_error_string, errorNoFormat, (LONGSIZ32)errorNum) ;

  if (parm2 == NULL) {
    if (parm1 == NULL) {   /* no params */
      (void)sprintf (temp, errorStr[index]); 
    }else {                   /* one param */
      (void)sprintf (temp, errorStr[index], parm1) ;
    }

  }else{                     /* two params */
    (void)sprintf (temp, errorStr[index], parm1, parm2) ;
  }
  
  (void)strcat(e1430_error_string, temp);

  if(e1430_printFlag) {
    (void)printf("%s\n", e1430_error_string);
  }

  if(e1430_returnError) {
    return (errorNum);
  }else{
    return (0);
  }
}

